/*+ DataLogging.cpp
 *
 ******************************************************************************
 *
 *                        Trimble Navigation Limited
 *                           645 North Mary Avenue
 *                              P.O. Box 3642
 *                         Sunnyvale, CA 94088-3642
 *
 ******************************************************************************
 *
 *    Copyright  2005 Trimble Navigation Ltd.
 *    All Rights Reserved
 *
 ******************************************************************************
 *
 * Description:
 *    This file implements the CDataLogging class.
 *            
 * Revision History:
 *    05-18-2005    Mike Priven
 *                  Written
 *
 * Notes:
 *
-*/

/*---------------------------------------------------------------------------*\
 |                         I N C L U D E   F I L E S
\*---------------------------------------------------------------------------*/
#include "stdafx.h"
#include "TsipDemo.h"
#include "DataLogging.h"
#include "TsipWindow.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/*---------------------------------------------------------------------------*\
 |                    M E T H O D   D E F I N I T I O N S
\*---------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
Function:       <constructor>

Description:    A constructor for this class. Called when a new object of this
                class is created.

Parameters:     pParent - a pointer to the parent window - the window that
                created an object of this class.

Return Value:   none
-----------------------------------------------------------------------------*/
CDataLogging::CDataLogging(CWnd* pParent /*=NULL*/)
    : CDialog(CDataLogging::IDD, pParent)
{
    m_pParent = (CTsipWindow*)pParent;
    //{{AFX_DATA_INIT(CDataLogging)
    m_bLogAscii = FALSE;
    m_bLogRaw = FALSE;
    m_strAsciiFile = _T("");
    m_strRawFile = _T("");
    //}}AFX_DATA_INIT
}

/*-----------------------------------------------------------------------------
Function:       DoDataExchange

Description:    Called by the framework to exchange and validate dialog data.
                Never call this function directly. It is called by the 
                UpdateData() member function

Parameters:     pDX - a pointer to a CDataExchange object

Return Value:   none
-----------------------------------------------------------------------------*/
void CDataLogging::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CDataLogging)
    DDX_Check(pDX, IDC_LOG_ASCII, m_bLogAscii);
    DDX_Check(pDX, IDC_LOG_RAW, m_bLogRaw);
    DDX_Text(pDX, IDC_ASCII_FILE, m_strAsciiFile);
    DDX_Text(pDX, IDC_RAW_FILE, m_strRawFile);
    //}}AFX_DATA_MAP
}

/*-----------------------------------------------------------------------------
Function:       BEGIN_MESSAGE_MAP (theClass, baseClass)

Description:    Defines a message map for this class. Matches a windows message
                with a callback function. The framework will call this function
                once the message associated with it has been received.

Parameters:     theClass - specifies the name of the class whose message map
                this is
                baseClass - specifies the name of the base class of theClass

Return Value:   none
-----------------------------------------------------------------------------*/
BEGIN_MESSAGE_MAP(CDataLogging, CDialog)
    //{{AFX_MSG_MAP(CDataLogging)
    ON_WM_CLOSE    ()
    ON_BN_CLICKED  (IDC_START, OnStart)
    //}}AFX_MSG_MAP
    ON_COMMAND     (IDC_CLOSE, OnClose)
END_MESSAGE_MAP()

/*-----------------------------------------------------------------------------
Function:       OnClose
    
Description:    This function is automatically called when a close button in
                in the upper right corner of the window is clicked on
                (the title-bar button with a cross). 

Parameters:     none

Return Value:   none
-----------------------------------------------------------------------------*/
void CDataLogging::OnClose() 
{
    EndDialog(IDCANCEL);
}

/*-----------------------------------------------------------------------------
Function:       OnCancel

Description:    This function is automatically called when the Escape key is 
                hit

Parameters:     none

Return Value:   none
-----------------------------------------------------------------------------*/
void CDataLogging::OnCancel() 
{
}

/*-----------------------------------------------------------------------------
Function:       OnInitDialog

Description:    Initialises the dialog box. This is a standard MFC function 
                called automatically after the dialog has been created but 
                before it is displayed.

Parameters:     none

Return Value:   specifies whether the application has set the input focus to 
                one of the controls in the dialog box
-----------------------------------------------------------------------------*/
BOOL CDataLogging::OnInitDialog() 
{
    CDialog::OnInitDialog();

    m_strAsciiFile = m_pParent->m_tLog.strAsciiFile;
    m_strRawFile  = m_pParent->m_tLog.strRawFile;
    m_bLogAscii    = m_pParent->m_tLog.bLogAscii;
    m_bLogRaw     = m_pParent->m_tLog.bLogRaw;

    ConfigureControls();

    UpdateData(false);

    return TRUE;
}

/*-----------------------------------------------------------------------------
Function:       OnStart

Description:    Called when the Start button is clicked

Parameters:     none

Return Value:   none
-----------------------------------------------------------------------------*/
void CDataLogging::OnStart() 
{
    if (!m_pParent->m_tLog.bLog)
    {
        if (UpdateData())
        {
            if (!m_bLogAscii && !m_bLogRaw)
            {
                AfxMessageBox ("Check either ASCII or TSIP checkbox to log data.");
                return;
            }

            if (m_bLogAscii && (m_strAsciiFile == ""))
            {
                AfxMessageBox ("Please, enter a file name for ASCII text file.");
                return;
            }

            if (m_bLogRaw && (m_strRawFile == ""))
            {
                AfxMessageBox ("Please, enter a file name for ASCII text file.");
                return;
            }

            m_pParent->m_tLog.strAsciiFile = m_strAsciiFile;
            m_pParent->m_tLog.strRawFile = m_strRawFile;
            m_pParent->m_tLog.bLogAscii = m_bLogAscii;
            m_pParent->m_tLog.bLogRaw = m_bLogRaw;
    
            m_pParent->ConfigureDataLog (TRUE);
        }
    }
    else
    {
        m_pParent->ConfigureDataLog (FALSE);
    }

    ConfigureControls();
}

/*-----------------------------------------------------------------------------
Function:       ConfigureControls

Description:    Called when the Stop button is clicked

Parameters:     none

Return Value:   none
-----------------------------------------------------------------------------*/
void CDataLogging::ConfigureControls ()
{
    if (m_pParent->m_tLog.bLog)
    {
        GetDlgItem(IDC_START)->SetWindowText("Stop Logging");
    }
    else
    {
        GetDlgItem(IDC_START)->SetWindowText("Start Logging");
    }
    GetDlgItem(IDC_LOG_ASCII)->EnableWindow(!m_pParent->m_tLog.bLog);
    GetDlgItem(IDC_LOG_RAW)->EnableWindow(!m_pParent->m_tLog.bLog);
    GetDlgItem(IDC_ASCII_FILE)->EnableWindow(!m_pParent->m_tLog.bLog);
    GetDlgItem(IDC_RAW_FILE)->EnableWindow(!m_pParent->m_tLog.bLog);
}
